<?php
/**
 * This file adds the enableunlayer column to the users table
 *
 * @package SendStudio
 * @subpackage Language
 */

/**
 * Make sure the upgrade system has been included.
 */
if (!class_exists('Upgrade_API', false)) {
	exit();
}

/**
 * Add the enableunlayer column to the users table
 *
 * @see Upgrade_API
 *
 * @package SendStudio
 * @subpackage Upgrades
 */
class users_add_enableunlayer_column extends Upgrade_API
{
	/**
	 * RunUpgrade
	 * Runs the add_enableunlayer_column upgrade process.
	 *
	 * @param Mixed $upgrade Details about the upgrade process.
	 *
	 * @return boolean Returns true if the upgrade was successful, otherwise returns false.
	 */
	function RunUpgrade($upgrade = false)
	{
		$query = "SHOW COLUMNS FROM " . SENDSTUDIO_TABLEPREFIX . "users LIKE 'enableunlayer'";
		$result = $this->Db->Query($query);
		
		// If the column already exists, we don't need to do anything
		if ($this->Db->CountResult($result) > 0) {
			return true;
		}
		
		// Add the enableunlayer column after enableactivitylog
		$query = "ALTER TABLE " . SENDSTUDIO_TABLEPREFIX . "users ADD COLUMN enableunlayer CHAR(1) DEFAULT '0' AFTER enableactivitylog";
		$result = $this->Db->Query($query);
		
		if (!$result) {
			return false;
		}
		
		return true;
	}
} 