<?php
/**
* This file is part of the upgrade process.
*
*  
*
* 
*/

/**
* Do a sanity check to make sure the upgrade api has been included.
*/
if (!class_exists('Upgrade_API', false)) {
	exit;
}

/**
* This class runs one change for the upgrade process.
* The Upgrade_API looks for a RunUpgrade method to call.
* That should return false for failure
* It should return true for success or if the change has already been made.
*
* @package SendStudio
*/
class config_settings_google_oauth extends Upgrade_API
{
	/**
	 * RunUpgrde
	 * Run current upgrade
	 * @return Boolean Returns TRUE if successful, FALSE otherwise
	 */
	function RunUpgrade($upgrade = false)
	{
		$queries[] = "INSERT INTO  " . SENDSTUDIO_TABLEPREFIX . "config_settings (area, areavalue) VALUES ('REFRESH_TOKEN', '')";
		$queries[] = "INSERT INTO  " . SENDSTUDIO_TABLEPREFIX . "config_settings (area, areavalue) VALUES ('REFRESH_TOKEN_STATUS', '')";
		$queries[] = "INSERT INTO  " . SENDSTUDIO_TABLEPREFIX . "config_settings (area, areavalue) VALUES ('GOOGLE_OAUTH_BOUNCE_EMAIL', '')";
		$queries[] = "INSERT INTO  " . SENDSTUDIO_TABLEPREFIX . "config_settings (area, areavalue) VALUES ('CLIENT_SECRET', '')";
		$queries[] = "INSERT INTO  " . SENDSTUDIO_TABLEPREFIX . "config_settings (area, areavalue) VALUES ('CLIENT_ID', '')";
		
		foreach($queries as $query){
			$result = $this->Db->Query($query);
		}

		if ($result == false) {
			return false;
		}

		return true;
	}
}
