<?php
/**
 * This file is part of the upgrade process.
 *
 * @package SendStudio
 */

/**
 * Do a sanity check to make sure the upgrade api has been included.
 */
if (!class_exists('Upgrade_API', false)) {
	exit;
}

/**
 * create_usergroups table
 *
 * @see Upgrade_API
 *
 * @package SendStudio
 */
class create_editors extends Upgrade_API
{
	/**
	 * RunUpgrade
	 * @return Boolean Returns TRUE if successful, FALSE otherwise
	 */
	function RunUpgrade($upgrade=false)
	{
		if ($this->TableExists('editors')) {
			return true;
		}

		$queries = [];
				 
		$queries[] = "CREATE TABLE  " . SENDSTUDIO_TABLEPREFIX."editors (
			id  varchar(30) NOT NULL PRIMARY KEY,
			name varchar(50) NOT NULL,
			description  varchar(100) NOT NULL,
			status  tinyint(1) NOT NULL DEFAULT 1,
			`default`  tinyint(1) NOT NULL DEFAULT 0
		) ENGINE=InnoDB DEFAULT CHARSET=utf8";	
	 
		$queries[] = "INSERT INTO ".SENDSTUDIO_TABLEPREFIX."editors (id, name, description, status, `default`) VALUES
			('1', 'WYSIWYG', 'TinyMCE Editor', 1, 0),
			('2', 'Unlayer', 'Use the Unlayer Editor', 1, 0),
			('3', 'BuilderJS', 'The BuilderJS Editor', 1, 1),
			('4', 'TextArea', 'Use the TextArea', 1, 0)
			";

		foreach ($queries as $query) {
			 
			$result = $this->Db->Query($query);
			
			if ($result == false) {
				return false;
			}
		}

		return true;
	}
}
