<style type="text/css">
  tr.Heading3 td {
    white-space: nowrap;
  }
  div.UserInfo img {
    margin-top: -3px;
  }

  div.NoRecords {
    padding-top: 50px;
    text-align: center;
  }

  table#ActionContainerTop {
    padding-top: 5px;
    border: 0;
    width: 100%;
  }

  table#ActionContainerTop div#deleteAccount {
    display: none;
  }
  table#ActionContainerTop div#deleteAccount img {
    border: 0;
    padding: 0 5px 0 0;
    margin: 0;
    vertical-align: middle;
  }
</style>
<table cellspacing="0" cellpadding="0" width="100%" align="center">
  <tr>
    <td class="Heading1">{$lang.Users}{if $groupInformation.groupid} : {$groupInformation.groupname}{/if}</td>
  </tr>
  <tr>
    <td class="body pageinfo"><p>{$lang.Help_Users}</p></td>
  </tr>
  {if trim($PAGE.messages) != ''}
  <tr>
    <td>{$PAGE.messages}</td>
  </tr>
  {/if}
  <tr>
    <td class="body">
      <form name="userform" method="post" action="index.php?Page=Users">
        <table id="ActionContainerTop">
          <tr>
            <td>
              <!-- short cut this is effectively 	{$FlashMessage({$PAGE.userreport}, SS_FLASH_MSG_WARNING)} -->
              {if $PAGE.userreport}
              <div class="border-l-4 border-yellow-400 rounded-md bg-yellow-50 p-4">
                <div class="flex items-center">
                  <div class="flex-shrink-0">
                    <svg class="h-5 w-5 text-yellow-400" viewBox="0 0 20 20" fill="currentColor" aria-hidden="true">
                      <path fill-rule="evenodd" d="M8.485 2.495c.673-1.167 2.357-1.167 3.03 0l6.28 10.875c.673 1.167-.17 2.625-1.516 2.625H3.72c-1.347 0-2.189-1.458-1.515-2.625L8.485 2.495zM10 5a.75.75 0 01.75.75v3.5a.75.75 0 01-1.5 0v-3.5A.75.75 0 0110 5zm0 9a1 1 0 100-2 1 1 0 000 2z" clip-rule="evenodd" />
                    </svg>
                  </div>
                  <div class="ml-3">
                    <h3 class="text-sm font-medium text-yellow-800">{$PAGE.userreport}</h3>
                  </div>
                </div>
              </div>

              {/if}
            </td>
            <td colspan="2" align="right" style="padding-bottom: 10px">
              <input type="text" class="Field250" size="20" value="{$quicksearchstring}" name="QuickSearchString" title="Search for emails in this mailing list." />
              <button id="SearchButton">
                {template="svg_searchicon"}
                <span>Search</span>
              </button>
              <input type="submit" value="search" style="display: none" />
            </td>
          </tr>
          <tr>
            <td>
              <input id="createAccountButton" type="button" class="FormButton" value="{$lang.UserAdd}" disabled="disabled" />
              {if count($records) != 0}
              <button id="deleteAccountButton" class="FormButton">{$lang.UserDeletePopDown}</button>
              <div id="deleteAccount" class="DropDownMenu DropShadow">
                <ul>
                  <li>
                    <a href="#N" title="{$lang.UserDeleteNoData_Summary}"> <img src="images/lists_view.gif" alt="icon" /> {$lang.UserDeleteNoData} </a>
                  </li>
                  <li>
                    <a href="#Y" title="{$lang.UserDeleteWithData_Summary}"> <img src="images/lists_view.gif" alt="icon" /> {$lang.UserDeleteWithData} </a>
                  </li>
                </ul>
              </div>
              {/if}
            </td>
            {if count($records) != 0}
            <td align="right" valign="bottom">{template="Paging"}</td>
            {/if}
          </tr>
        </table>
        {if count($records) == 0}
        <div class="NoRecords">{$lang.SearchRecordNotFound}</div>
        {else}
        <table border="0" cellspacing="0" cellpadding="0" width="100%" class="Text" id="UserListTable">
          <tr class="Heading3">
            <td width="5" nowrap align="center">
              <input type="checkbox" name="toggle" class="UICheckboxToggleSelector" />
            </td>
            <td width="5">&nbsp;</td>
            <td width="24%">
              {$lang.UserName}
              <a href="index.php?Page=Users&SortBy=username&Direction=Up">{template="svg_chevron_up"}</a>
              <a href="index.php?Page=Users&SortBy=username&Direction=Down">{template="svg_chevron_down"}</a>
            </td>
            <td width="24%">
              {$lang.FullName}
              <a href="index.php?Page=Users&SortBy=fullname&Direction=Up">{template="svg_chevron_up"}</a>
              <a href="index.php?Page=Users&SortBy=fullname&Direction=Down">{template="svg_chevron_down"}</a>
            </td>
            <td width="12%">
              {$lang.UserType}
              <a href="index.php?Page=Users&SortBy=admintype&Direction=Up">{template="svg_chevron_up"}</a>
              <a href="index.php?Page=Users&SortBy=admintype&Direction=Down">{template="svg_chevron_down"}</a>
            </td>
            <td width="15%">
              {$lang.UsersGroups}
              <a href="index.php?Page=Users&SortBy=usergroup&Direction=Up">{template="svg_chevron_up"}</a>
              <a href="index.php?Page=Users&SortBy=usergroup&Direction=Down">{template="svg_chevron_down"}</a>
            </td>
            <td width="12%">
              {$lang.UserCreatedOn}
              <a href="index.php?Page=Users&SortBy=createdate&Direction=Up">{template="svg_chevron_up"}</a>
              <a href="index.php?Page=Users&SortBy=createdate&Direction=Down">{template="svg_chevron_down"}</a>
            </td>
            <td width="12%">
              {$lang.LastLoggedIn}
              <a href="index.php?Page=Users&SortBy=lastloggedin&Direction=Up">{template="svg_chevron_up"}</a>
              <a href="index.php?Page=Users&SortBy=lastloggedin&Direction=Down">{template="svg_chevron_down"}</a>
            </td>
            <td width="15">
              {$lang.UserStatusColumn}
              <a href="index.php?Page=Users&SortBy=status&Direction=Up">{template="svg_chevron_up"}</a>
              <a href="index.php?Page=Users&SortBy=status&Direction=Down">{template="svg_chevron_down"}</a>
            </td>
            <td width="70">{$lang.Action}</td>
          </tr>
          {foreach from=$records item=each}
          <tr class="GridRow UserRecordRow">
            <td valign="top" align="center"><input type="checkbox" name="users[]" value="{$each.userid}" class="UICheckboxToggleRows" /></td>
            <td>
              <div class="rowImage"><img src="images/user.gif" alt="user_icon" /></div>
            </td>
            <td>{$each.username}</td>
            <td>{if trim($each.fullname) == ''}{$lang.N/A}{else}{$each.fullname}{/if}</td>
            <td style="white-space: nowrap">{if $each.admintype == 'a'} {$lang.AdministratorType_SystemAdministrator} {elseif $each.admintype == 'l'} {$lang.AdministratorType_ListAdministrator} {elseif $each.admintype == 'n'} {$lang.AdministratorType_NewsletterAdministrator} {elseif $each.admintype == 't'} {$lang.AdministratorType_TemplateAdministrator} {elseif $each.admintype == 'u'} {$lang.AdministratorType_UserAdministrator} {elseif !$each.trialuser} {$lang.AdministratorType_RegularUser} {else} {$lang.AdministratorType_TrialUser} {/if}</td>
            <td style="white-space: nowrap">{$each.groupname}</td>
            <td>{$each.processed_CreateDate}</td>
            <td style="white-space: nowrap">{$each.processed_LastLoggedIn}</td>
            <td align="center">
              {if $each.status == '0'}
              	{template="svg_cross"}
              {elseif $each.status == '1'}
                {template="svg_tick"}
              {else} - {/if}
            </td>
            <td style="white-space: nowrap">
              <a href="index.php?Page=Users&Action=Edit&UserID={$each.userid}">{$lang.Edit}</a>
              {if $each.userid != $PAGE.currentuserid} &nbsp;<a href="index.php?page=AdminTools&action=disguise&newID={$each.userid}" class="ActionLink ActionType_disguise">{$lang.LoginAsUser}</a>
              {/if}
            </td>
          </tr>
          {/foreach}
        </table>
        {/if}
      </form>
      {* Bottom pagination -- Only print if records are available *} {if count($records) != 0}{template="Paging_Bottom"}{/if}
    </td>
  </tr>
</table>
<script type="text/javascript">
  $(function() {
  	Application.Ui.CheckboxSelection(	'table#UserListTable',
  										'input.UICheckboxToggleSelector',
  										'input.UICheckboxToggleRows');

  	$(document.userform.QuickSearchString).focus(function() {
  		if (this.readonly) {
  			this.value = '';
  		}

  		this.readonly = false;
  		$(this).css('color', '');
  		this.select();
  	});

  	$(document.userform.QuickSearchString).blur(function() { EvaluateQuickSearch(); });
  	EvaluateQuickSearch();

  	{if count($records) == 0}
  		$(document.userform.QuickSearchString).focus();
  	{else}
  		$('table#UserListTable').click(function(e) {
  			if (!$(e.target).is('a.ActionType_disguise')) return;
  			var matches = $(e.target).attr('href').match(/(.*?)&newID=(\d+)$/);

  			if (matches.length == 3) {
  				Application.Util.submitPost(matches[1], {newUserID:matches[2]});
  			}

  			e.stopPropagation();
  			e.preventDefault();
  			return false;
  		});

  		$('div#deleteAccount a').click(function(e) {
  			e.preventDefault();

  			var deleteData = ($(this).attr('href').match(/^#Y/) == '#Y');
  			var selectedIDs = [];
  			var selectedRows = $('table tr.UserRecordRow input.UICheckboxToggleRows[type=checkbox]:checked');
  			for(var i = 0, j = selectedRows.size(); i < j; ++i) selectedIDs.push(selectedRows.get(i).value);

  			if (selectedRows.length == 0) {
  				alpineAlert("{$lang.ChooseUsersToDelete}");
  				return true;
  			}

  			if ($.inArray('{$PAGE.currentuserid}', selectedIDs) != -1) {
  				alpineAlert("{$lang.User_CantDeleteOwn}");
  				return true;
  			}

  			if (!confirm(deleteData ? "{$lang.ConfirmRemoveUsersWithData}" : "{$lang.ConfirmRemoveUsers}")) {
  				return true;
  			}

  			$('button#deleteAccountButton', document.userform).attr('disabled', true);
  			Application.Util.submitPost('index.php?Page=Users&Action=Delete', {users:selectedIDs, deleteData:(deleteData ? '1' : '0')});
  			return true;
  		});
  	{/if}

  	$('input#createAccountButton', document.userform).click(function() {
  		document.location="index.php?Page=Users&Action=Add";
  	});

  	Application.Ui.Menu.PopDown('button#deleteAccountButton', {topMarginPixel: -3});
  });

  function DeleteSelectedUsers(formObj) {
  	users_found = 0;
  	for (var i=0;i < formObj.length;i++)
  	{
  		fldObj = formObj.elements[i];
  		if (fldObj.type == 'checkbox')
  		{
  			if (fldObj.checked) {
  				users_found++;
  				break;
  			}
  		}
  	}

  	if (users_found <= 0) {
  		alpineAlert("%%LNG_ChooseUsersToDelete%%");
  		return false;
  	}

    alpineConfirm('%%LNG_ConfirmRemoveUsers%%', '', 'OK', 'Cancel', function() {
        formObj.submit();
    });
  	return false;
  }

  function EvaluateQuickSearch() {
  	var elm = document.userform.QuickSearchString;
  	if(elm.value.trim() == '') {
  		$(elm).css('color', '#999999');
  		elm.value = '{$lang.QuickUserSearchIntro}';
  		elm.readonly = true;
  	}
  }
</script>
