<!DOCTYPE html>
<html>
  <head>
    <title>%%GLOBAL_ApplicationTitle%%</title>
    <link rel="shortcut icon" href="%%GLOBAL_ApplicationFavicon%%" type="image/vnd.microsoft.icon" />
    <link rel="icon" href="%%GLOBAL_ApplicationFavicon%%" type="image/vnd.microsoft.icon" />
    <meta http-equiv="Content-Type" content="text/html; charset=%%GLOBAL_CHARSET%%" />
    <!-- <link rel="stylesheet" href="includes/styles/stylesheet.css" type="text/css" /> -->
    <!-- <link rel="stylesheet" href="includes/styles/tabmenu.css" type="text/css" /> -->
    <link rel="stylesheet" href="includes/styles/thickbox.css" type="text/css" />
    <link rel="stylesheet" href="includes/js/imodal/imodal.css" type="text/css" />
    <link rel="stylesheet" href="includes/styles/tailwind.min.css" />

    <script src="includes/js/jquery.js" type="text/javascript"></script>
    <script src="includes/js/jquery/jquery.json-1.3.min.js" type="text/javascript"></script>
    <script src="includes/js/jquery/thickbox.js" type="text/javascript"></script>
    <script src="includes/js/javascript.js" type="text/javascript"></script>
    <script src="includes/js/tiny_mce/tinymce.min.js" type="text/javascript"></script>
    <script src="includes/js/amcharts/amcharts.js" type="text/javascript"></script>
    <script src="includes/js/amcharts/pie.js" type="text/javascript"></script>
    <script src="includes/js/amcharts/serial.js" type="text/javascript"></script>
    <script src="includes/js/alpine/alpine.min.js" defer></script>
    <script src="includes/js/alpine/plugins/alpine.validate.min.js" defer></script>
    <script src="includes/js/alpine/plugins/alpine.focus.min.js" defer></script>
    <script src="includes/js/iodine/iodine.min.js" defer></script>

    <script type="text/javascript">
      AmCharts.loadJSON = function (url) {
        // create the request
        if (window.XMLHttpRequest) {
          // IE7+, Firefox, Chrome, Opera, Safari
          var request = new XMLHttpRequest();
        } else {
          // code for IE6, IE5
          var request = new ActiveXObject("Microsoft.XMLHTTP");
        }
        request.open("GET", url, false);
        request.send();
        return JSON.parse(request.responseText);
      };
    </script>

    <script type="text/javascript">
      var UnsubLinkPlaceholder = "%%LNG_UnsubLinkPlaceholder%%";
      var UsingWYSIWYG = "%%GLOBAL_UsingWYSIWYG%%";
      var Searchbox_Type_Prompt = "%%LNG_Searchbox_Type_Prompt%%";
      var Searchbox_List_Info = "%%GLOBAL_Searchbox_List_Info%%";
      var Application_Title = "%%LNG_ApplicationTitle%%";

      Application.Misc.specifyDocumentMinWidth(935);
      Application.Misc.setPingServer("ping.php", 120000);
    </script>

    <script type="text/javascript">

      var IDLE_TIMEOUT_MIN =<?php if(SENDSTUDIO_SECURITY_SESSION_TIME == ''){ echo 60 ;}else {echo SENDSTUDIO_SECURITY_SESSION_TIME; } ?>;
      var IDLE_TIMEOUT = IDLE_TIMEOUT_MIN;  //   minutes of inactivity
      var _idleMinutesCounter = 0;
      document.onclick = function() {
      	_idleMinutesCounter = 0;
      };
      document.onmousemove = function() {
      	_idleMinutesCounter = 0;
      };
      document.onkeypress = function() {
      	_idleMinutesCounter = 0;
      };
      window.setInterval(CheckIdleTime, 60000);
      function CheckIdleTime() {
        _idleMinutesCounter++;

        if (_idleMinutesCounter >= IDLE_TIMEOUT) {
          if(IDLE_TIMEOUT != 0){
            // destroy the session
            window.location="index.php?Page=Logout";
          }
        }
      }
    </script>
  </head>

  <body>
    {if $TrialNotification}
    <div id="IEM_Header_TrialNotificationBar">{$TrialNotification}</div>
    {/if}
    <div id="IEM_HTML_Body">
      <div class="Header">
        <div class="Header_Top"></div>

          <div class="min-h-full" x-data="{ currentPath: window.location.pathname }">
            <nav class="bg-white w-full">
              <!-- Flex container for logo and menu -->
              <div class="flex justify-between w-full">
                <!-- Logo -->
                <div class="logo">
                <a href="index.php"><img id="logo" src="%%WHITELABEL_ApplicationLogoImage%%" alt="Interspire Email Marketer" border="0"></a>
                </div>
          
                <!-- Menu and user info -->
                <div class="">
                  <div x-data="{ open: false }" id="topMenu"><div class="flex items-center justify-end space-x-1" x-data="{ open: null }">%%GLOBAL_TextLinks%%</div></div>
                  <div class="loggedinas text-right">%%GLOBAL_UserLoggedInAs%%%%GLOBAL_SystemDateTime%%</div>
                  <span class="emailcredits">%%GLOBAL_MonthlyEmailCredits%%</span>
                  <span class="emailcredits">%%GLOBAL_TotalEmailCredits%%</span>
                </div>
              </div>
            </nav>

            <div class="Header_Bottom"></div>
          </div>
	      </div>

	      <div class="menuBar">
		      <div style="height:0px;">&nbsp;</div>
		      <div>%%GLOBAL_MenuLinks%%</div>
	      </div>

        <div class="ContentContainer">
          <div class="BodyContainer">
            {if $ShowTestModeWarning}
              <div class="border-l-4 border-yellow-400 rounded-md bg-yellow-50 p-4 mb-2">
                <div class="flex items-center">
                  <div class="flex-shrink-0">
                    <svg class="h-5 w-5 text-yellow-400" viewBox="0 0 20 20" fill="currentColor" aria-hidden="true">
                      <path fill-rule="evenodd" d="M8.485 2.495c.673-1.167 2.357-1.167 3.03 0l6.28 10.875c.673 1.167-.17 2.625-1.516 2.625H3.72c-1.347 0-2.189-1.458-1.515-2.625L8.485 2.495zM10 5a.75.75 0 01.75.75v3.5a.75.75 0 01-1.5 0v-3.5A.75.75 0 0110 5zm0 9a1 1 0 100-2 1 1 0 000 2z" clip-rule="evenodd" />
                    </svg>
                  </div>
                  <div class="ml-3">
                    <h3 class="text-sm font-medium text-yellow-800">{$SendTestWarningMessage}</h3>
                  </div>
                </div>
              </div>
            {/if}

	        %%GLOBAL_BodyAddons%%
