/**
	 * @name        initFile
	 * @description Initializes the file upload widget.
	 * @return      Void
	 * @param       context - The context to use for initialization.
	 */
	this.initFile = function(context)
	{
		// when the file types checkbox is checked, hide the file types field, when it is
		// unchecked, show the file types field
		$('.form-element-file-types :checkbox', context).bond('click', function() {
			if (this.checked) {
				$('.form-element-file-types span', context).hide();
			} else {
				$('.form-element-file-types span', context).show();
			}
		});
	};
	
	/**
	 * @name        initRadio
	 * @description Initializes the radio list widget.
	 * @return      Void
	 * @param       context - The context to use for initialization.
	 */
	this.initRadio = function(context, showFirst)
	{
		_initOptions(context, showFirst);
		_initOther(context);
	};
	
	/**
	 * @name        initSelect
	 * @description Initializes the select list widget.
	 * @return      Void
	 * @param       context - The context to use for initialization.
	 */
	this.initSelect = function(context, showFirst)
	{
		_initOptions(context, showFirst);
	};
	
	/**
	 * @name        initSelectCountries
	 * @description Initializes the country select list variation of the select widget.
	 * @return      Void
	 * @param       context - The context to use for initialization.
	 */
	this.initSelectCountry = function(context)
	{
		this.initSelect(context, false);
		
		var fillData   = { fieldData : [] };
		var countryList = [
				'Afghanistan',
				'Albania',
				'Algeria',
				'Andorra',
				'Angola',
				'Antigua and Barbuda',
				'Argentina',
				'Armenia',
				'Australia',
				'Austria',
				'Azerbaijan',
				'Bahamas',
				'Bahrain',
				'Bangladesh',
				'Barbados',
				'Belarus',
				'Belgium',
				'Belize',
				'Benin',
				'Bhutan',
				'Bolivia',
				'Bosnia and Herzegovina',
				'Botswana',
				'Brazil',
				'Brunei',
				'Bulgaria',
				'Burkina Faso',
				'Burundi',
				'Cambodia',
				'Cameroon',
				'Canada',
				'Cape Verde',
				'Central African Republic',
				'Chad',
				'Chile',
				'China',
				'Colombi',
				'Comoros',
				'Congo (Brazzaville)',
				'Congo',
				'Costa Rica',
				"Cote d'Ivoire",
				'Croatia',
				'Cuba',
				'Cyprus',
				'Czech Republic',
				'Denmark',
				'Djibouti',
				'Dominica',
				'Dominican Republic',
				'East Timor (Timor Timur)',
				'Ecuador',
				'Egypt',
				'El Salvador',
				'Equatorial Guinea',
				'Eritrea',
				'Estonia',
				'Ethiopia',
				'Fiji',
				'Finland',
				'France',
				'Gabon',
				'Gambia, The',
				'Georgia',
				'Germany',
				'Ghana',
				'Greece',
				'Grenada',
				'Guatemala',
				'Guinea',
				'Guinea-Bissau',
				'Guyana',
				'Haiti',
				'Honduras',
				'Hungary',
				'Iceland',
				'India',
				'Indonesia',
				'Iran',
				'Iraq',
				'Ireland',
				'Israel',
				'Italy',
				'Jamaica',
				'Japan',
				'Jordan',
				'Kazakhstan',
				'Kenya',
				'Kiribati',
				'Korea, North',
				'Korea, South',
				'Kuwait',
				'Kyrgyzstan',
				'Laos',
				'Latvia',
				'Lebanon',
				'Lesotho',
				'Liberia',
				'Libya',
				'Liechtenstein',
				'Lithuania',
				'Luxembourg',
				'Macedonia',
				'Madagascar',
				'Malawi',
				'Malaysia',
				'Maldives',
				'Mali',
				'Malta',
				'Marshall Islands',
				'Mauritania',
				'Mauritius',
				'Mexico',
				'Micronesia',
				'Moldova',
				'Monaco',
				'Mongolia',
				'Morocco',
				'Mozambique',
				'Myanmar',
				'Namibia',
				'Nauru',
				'Nepa',
				'Netherlands',
				'New Zealand',
				'Nicaragua',
				'Niger',
				'Nigeria',
				'Norway',
				'Oman',
				'Pakistan',
				'Palau',
				'Panama',
				'Papua New Guinea',
				'Paraguay',
				'Peru',
				'Philippines',
				'Poland',
				'Portugal',
				'Qatar',
				'Romania',
				'Russia',
				'Rwanda',
				'Saint Kitts and Nevis',
				'Saint Lucia',
				'Saint Vincent',
				'Samoa',
				'San Marino',
				'Sao Tome and Principe',
				'Saudi Arabia',
				'Senegal',
				'Serbia and Montenegro',
				'Seychelles',
				'Sierra Leone',
				'Singapore',
				'Slovakia',
				'Slovenia',
				'Solomon Islands',
				'Somalia',
				'South Africa',
				'Spain',
				'Sri Lanka',
				'Sudan',
				'Suriname',
				'Swaziland',
				'Sweden',
				'Switzerland',
				'Syria',
				'Taiwan',
				'Tajikistan',
				'Tanzania',
				'Thailand',
				'Togo',
				'Tonga',
				'Trinidad and Tobago',
				'Tunisia',
				'Turkey',
				'Turkmenistan',
				'Tuvalu',
				'Uganda',
				'Ukraine',
				'United Arab Emirates',
				'United Kingdom',
				'United States',
				'Uruguay',
				'Uzbekistan',
				'Vanuatu',
				'Vatican City',
				'Venezuela',
				'Vietnam',
				'Yemen',
				'Zambia',
				'Zimbabwe'
			];
		
		for (var i = 0; i < countryList.length; i++) {
			fillData.fieldData[i] = {
					label : countryList[i]
				};
		}
		
		_addFields(context, fillData.fieldData);
		_fillWidget(context, fillData);
	};
	
	/**
	 * @name        initText
	 * @description Initializes the text widget.
	 * @return      Void
	 * @param       context - The context to use for initialization.
	 */
	this.initText = function(context)
	{
		
	};
	
	/**
	 * @name        initTextarea
	 * @description Initializes the textarea widget.
	 * @return      Void
	 * @param       context - The context to use for initialization.
	 */
	this.initTextarea = function(context)
	{
		
	};